//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Argument and local variables - begin with a lowercase letter followed by
//        lowercase words separated by underscores.
//        (E.G., int my_local;).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


#ifndef _SGB_ARROW_BUTTON_H_
#define _SGB_ARROW_BUTTON_H_


//******************************************************************************************************
//**** SYSTEM HEADER FILES
//******************************************************************************************************
#include <Control.h>


//******************************************************************************************************
//**** PROJECT HEADER FILES
//******************************************************************************************************


//******************************************************************************************************
//**** TYPE DEFINITIONS AND CONSTANTS
//******************************************************************************************************
enum ArrowOrientation
{
	ARROW_UP = 0,
	ARROW_LEFT,
	ARROW_RIGHT,
	ARROW_DOWN
};

enum ArrowBitmaps
{
	ARROW_DISABLED = 0,
	ARROW_ENABLED,
	ARROW_ACTIVE
};


//******************************************************************************************************
//**** ArrowButton CLASS
//******************************************************************************************************
class ArrowButton: public BControl
{
	public:
		ArrowButton(BRect frame, const char *name, const char *label, BMessage *message,
			ArrowOrientation orientation, uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP, 
			uint32 flags = B_WILL_DRAW | B_NAVIGABLE);
		~ArrowButton();
		virtual void AttachedToWindow();
		virtual	void WindowActivated(bool state);
		virtual void Draw(BRect update_rect);
		virtual	void MouseDown(BPoint pt);
		virtual void SetEnabled(bool on);
		virtual	void GetPreferredSize(float *width, float *height);
		virtual void SetScrollEnabled(bool state);
		bool GetScrollEnabled();
	private:
		static int32 FollowMouse(void* data);
		bool m_window_activated;
		BBitmap* m_bitmaps[3];	//indexed by ArrowBitmaps type
		BRect m_arrow_rect;
		ArrowOrientation m_orientation;
		bool m_scroll_enabled;
};


#endif